
"""


Auteur: anonyme

Interface: microbit

Nom du projet: Alarme de tiroir

Description: No-description

Toolbox: vittascience

Mode: blocks

Blocks: <xml xmlns="https://developers.google.com/blockly/xml"><block type="on_start" id="G[=T#8yqB70`NFgYq}GP" deletable="false" x="-338" y="63"></block><block type="forever" id="o[WN]+eeF.OUxGch67@8" x="312" y="37"><statement name="DO"><block type="controls_if" id="!86I+U@lD1)p~.ja^:N:"><mutation else="1"></mutation><value name="IF0"><block type="logic_compare" id="BnY,0Ava%r.8dEETNW(h"><field name="OP">GT</field><value name="A"><block type="sensors_getLight" id="gfL%Z8ORy{a/3on`mz5{"></block></value><value name="B"><shadow type="math_number" id="G~^m=|$(Au0IU$kiylbv"><field name="NUM">10</field></shadow></value></block></value><statement name="DO0"><block type="controls_repeat" id="L?{m}c7`ra?W0qU/s.{]"><value name="TIMES"><shadow type="math_number" id="Va01W4Jz/!tSe;lM:2[6"><field name="NUM">4</field></shadow></value><statement name="DO"><block type="display_setGroveSocketLed" id="yggdcueFkt0vme`9zM*2"><field name="PIN">pin0</field><value name="STATE"><shadow type="io_digital_signal" id=":_3l`8`5O(^V1N+ym7^M"><field name="BOOL">HIGH</field></shadow></value><next><block type="actuators_playMusicGroveBuzzer" id="-703H^rIZ3s~Wr}I6u-n"><field name="MUSIC">R2D2</field><field name="PIN">pin_speaker</field><next><block type="display_setGroveSocketLed" id="!mi?L3L`N|6g%v!Jb7pr"><field name="PIN">pin0</field><value name="STATE"><shadow type="io_digital_signal" id="g^,rd^r)Bujm;axHz2iH"><field name="BOOL">LOW</field></shadow></value></block></next></block></next></block></statement><next><block type="io_pause" id="=c2~.uB=@F[E%}/PzSV7"><field name="UNIT">SECOND</field><value name="TIME"><shadow type="math_number" id="hf`UBu[^k/!P/qf68f*K"><field name="NUM">0.5</field></shadow></value></block></next></block></statement><statement name="ELSE"><block type="display_setGroveSocketLed" id="p1V$wUeV|*E:f%_t~n_*"><field name="PIN">pin0</field><value name="STATE"><shadow type="io_digital_signal" id="m{FH/{ZObL#f`S0mMei0"><field name="BOOL">LOW</field></shadow></value><next><block type="io_pause" id="DxSn8}?D0)!95NcY(`br"><field name="UNIT">SECOND</field><value name="TIME"><shadow type="math_number" id="n5Pg3Ov=Sm:MB+qkxces"><field name="NUM">0.5</field></shadow></value></block></next></block></statement></block></statement></block></xml>

Projet généré par Vittascience.

Ce fichier contient le code textuel ainsi que le code blocs. Il peut être importé de nouveau

sur l'interface http://vittascience.com/microbit


"""

from microbit import *
import utime

# LED Module on pin0
# Buzzer on pin_speaker

def pitch(pin, noteFrequency, noteDuration, silence_ms = 10):
  if noteFrequency is not 0:
    microsecondsPerWave = 1e6 / noteFrequency
    millisecondsPerCycle = 1000 / (microsecondsPerWave * 2)
    loopTime = noteDuration * millisecondsPerCycle
    for x in range(loopTime):
      pin.write_digital(1)
      utime.sleep_us(int(microsecondsPerWave))
      pin.write_digital(0)
      utime.sleep_us(int(microsecondsPerWave))
  else:
    utime.sleep_ms(noteDuration)
  utime.sleep_ms(silence_ms)

def BuzzerR2D2(pin):
  R2D2_NOTES = [3520, 3135.96, 2637.02, 2093, 2349.32, 3951.07, 2793.83, 4186.01, 3520, 3135.96, 2637.02, 2093, 2349.32, 3951.07, 2793.83, 4186.01]
  for i in range(len(R2D2_NOTES)):
    pitch(pin, R2D2_NOTES[i], 80, 20)

while True:
  if display.read_light_level() > 10:
    for count in range(4):
      pin0.write_digital(1)
      BuzzerR2D2(pin_speaker)
      pin0.write_digital(0)
    utime.sleep(0.5)
  else:
    pin0.write_digital(0)
    utime.sleep(0.5)
